/*
	This script must be executed on the @GOLD_SERVER@. 
	
	It restores VBECS database backup from @GOLD_SERVER@\AutobuildDBBackups

	Assumes directories follow standard conventions
*/

USE [master];

IF SERVERPROPERTY( 'MachineName' ) <> '@GOLD_SERVER@'
	THROW 62001, N'This script must be run only on @GOLD_SERVER@', 1;

IF EXISTS( SELECT 1 FROM master.dbo.sysdatabases WHERE [name] = '@UT_DB_NAME@' ) 
	BEGIN

		DECLARE @activeDbUsers TABLE ( DbUserID INT IDENTITY(1,1), UserSpid SMALLINT NOT NULL )

		INSERT INTO @activeDbUsers( UserSpid )
		SELECT spid
		FROM master.sys.sysprocesses P
		JOIN master.sys.sysdatabases D ON P.dbid = D.dbid
		WHERE D.[name] = '@UT_DB_NAME@' AND spid <> @@SPID

		IF @@ERROR <> 0 THROW 62002, N'Error occurred while trying to fetch a list of users to kill', 1

		DECLARE @killsql NVARCHAR(4000), @userRecordId INT, @numberOfUsersToKill INT, @errorBuf INT, @returnCode INT
	
		SELECT @numberOfUsersToKill = COUNT(1) FROM @activeDbUsers
		SET @userRecordId = 1

		WHILE @userRecordId <= @numberOfUsersToKill
		BEGIN
			SELECT @killsql = N'KILL ' + CAST( UserSpid AS NVARCHAR(30) ) 
			FROM @activeDbUsers 
			WHERE DbUserID = @userRecordId
		
			IF @@ERROR <> 0 THROW 62003, N'Error occurred while trying to prepare dynamic SQL to kill user', 1

			EXEC( @killsql )
		
			IF @@ERROR <> 0 THROW 62004, N'Error occurred while trying to kill active user with dynamic SQL', 1

			SET @userRecordId = @userRecordId + 1
		END
		
		SET @killsql = 'DROP DATABASE [@UT_DB_NAME@]';
		EXEC sp_executesql @killsql
		IF @@ERROR <> 0 THROW 62014, N'Drop database @UT_DB_NAME@ failed!!', 1		
	END


/*****************************************GET THE DATABASE FILE INFO ***************************/
DECLARE @FileListInfo TABLE(
 LogicalName NVARCHAR(128) 
,PhysicalName NVARCHAR(260) 
,Type CHAR(1) 
,FileGroupName NVARCHAR(128) 
,Size numeric(20,0) 
,MaxSize numeric(20,0) 
,FileId INT 
,CreateLSN numeric(25,0) 
,DropLSN numeric(25,0) 
,UniqueId uniqueidentifier 
,ReadOnlyLSN numeric(25,0) 
,ReadWriteLSN numeric(25,0) 
,BackupSizeInBytes BIGINT 
,SourceBlockSize INT 
,FilegroupId INT 
,LogGroupGUID uniqueidentifier 
,DifferentialBaseLSN numeric(25) 
,DifferentialBaseGUID uniqueidentifier 
,IsReadOnly INT 
,IsPresent INT 
,TDEThumbprint NVARCHAR(128)
)

INSERT @FileListInfo
EXEC('RESTORE FILELISTONLY FROM DISK = N''\\@GOLD_SERVER@\AutobuildFiles\@DB_NAME@_FOR_UNITTEST.BAK''')
IF @@ERROR <> 0 THROW 62029, N'Error getting filelist', 1 


DECLARE @dataFileName VARCHAR(255)
DECLARE @DataFilePath NVARCHAR(1000)
SELECT @DataFilePath = SUBSTRING(PhysicalName, 1, CHARINDEX(N'\DATA', PhysicalName) + 5), @dataFileName = LogicalName
FROM @FileListInfo WHERE FileId = 1

--Get the path of the Log file
DECLARE @LogFilePath NVARCHAR(1000)
DECLARE @logFileName VARCHAR(255)
SELECT @LogFilePath = SUBSTRING(PhysicalName, 1, CHARINDEX(N'\DATA', PhysicalName) + 5), @logFileName = LogicalName
FROM @FileListInfo WHERE FileId = 2

--Get the path of the Full text data file (if it exists)
DECLARE @FTRowFilePath NVARCHAR(1000)
DECLARE @ftrowFileName VARCHAR(255)
DECLARE @ftrowInfo NVARCHAR(1000)
SET @ftrowInfo = ''
SELECT @FTRowFilePath = SUBSTRING(PhysicalName, 1, CHARINDEX(N'\DATA', PhysicalName) + 5), @ftrowFileName = LogicalName 
FROM @FileListInfo WHERE FileId = 3
IF @@ROWCOUNT <> 0 SET @ftrowInfo = N',     MOVE ''' + @ftrowFileName + ''' TO '''+ @FTRowFilePath + N'ftrow_@UT_DB_NAME@.ndf'''

DECLARE @sql NVARCHAR(4000)
SET @sql = N'RESTORE DATABASE [@UT_DB_NAME@] ' +
       N'FROM DISK = N''\\@GOLD_SERVER@\AutobuildFiles\@DB_NAME@_FOR_UNITTEST.BAK'' ' +
 	   N'WITH MOVE ''' + @dataFileName  + ''' TO ''' + @DataFilePath + N'@UT_DB_NAME@_Data.mdf'', '+ 
	   N'     MOVE ''' + @logFileName + ''' TO ''' + @LogFilePath + N'@UT_DB_NAME@_Log.ldf'''
	   + @ftrowInfo

EXEC sp_executesql @sql
IF @@ERROR <> 0 THROW 62005, N'Error Restoring @UT_DB_NAME@', 1

-- Just in case the database is in READ-ONLY mode, make it writable -- Mike likes to do this!!! SMITHHHHHHHHHHH!!!
SET @sql = 'ALTER DATABASE @UT_DB_NAME@ SET READ_WRITE'
EXEC sp_executesql @sql
IF @@ERROR <> 0 THROW 62006, N'Error clearing read-only on @UT_DB_NAME@', 1

SET @sql = 'ALTER DATABASE @UT_DB_NAME@ MODIFY FILE (NAME =''' + @dataFileName + ''', NEWNAME =''@UT_DB_NAME@_DATA'')'
EXEC sp_executesql @sql 
IF @@ERROR <> 0 THROW 62007, N'Error renaming data file for @UT_DB_NAME@', 1

SET @sql = 'ALTER DATABASE @UT_DB_NAME@ MODIFY FILE (NAME =''' + @logFileName + ''', NEWNAME =''@UT_DB_NAME@_LOG'')'
EXEC sp_executesql @sql
IF @@ERROR <> 0 THROW 62008, N'Error renaming log file for @UT_DB_NAME@', 1

IF @ftrowInfo <> ''
BEGIN
	SET @sql = 'ALTER DATABASE @UT_DB_NAME@ MODIFY FILE (NAME =''' + @ftrowFileName + ''', NEWNAME =''@UT_DB_NAME@_FTROW'')'
	EXEC sp_executesql @sql
	IF @@ERROR <> 0 THROW 62009, N'Error renaming ftrow file for @UT_DB_NAME@', 1 
END



